#include <tchar.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

#include "stsmon.h"

#define SMJPRINTER_PRINTER_NAME      _T("TSP700II - Ethernet:TCP:")                                                        // Printer Queue Name
#define SMJPRINTER_LMPLUGREG_NAME    _T("SOFTWARE\\StarMicronics\\SMJLMHOST2\\Star TSP700II (TSP743II)")          // TSP700II registry storage destination
#define SMJPRINTER_STLM_NAME         _T("stlm.dll")                                                               // Star Language Monitor
#define SMJPRINTER_STSMON_NAME       _T("stsmon.dll")                                                             // Star Status   Monitor
#define GUID_MAX_LENGTH              1024

void StatusCheck(HMODULE hPLUGINDLL)
{
    wchar_t  raw[256]; memset(&raw, 0, sizeof(raw));
    DWORD    i = 0;
    int      j = 0;
    DWORD    dwError;

    if( hPLUGINDLL != NULL )
    {

        STATUSCHK stlmplugIn = (STATUSCHK) GetProcAddress(hPLUGINDLL, GetStarPrinterStatus);

        if(stlmplugIn != NULL)
        {
            StarPrinterStatus status;
            memset(&status, 0, sizeof(StarPrinterStatus));

            if((*stlmplugIn)(SMJPRINTER_PRINTER_NAME, &status))
            {
                // The error status value is 1 (true). 
                wprintf(_T("Printer Name: %s\n"), SMJPRINTER_PRINTER_NAME);
                if(status.coverOpen              != 0) { wprintf(_T("1->coverOpen\n"));              }else{ wprintf(_T("0->coverOpen\n"));              }
                if(status.offline                != 0) { wprintf(_T("1->offline\n"));                }else{ wprintf(_T("0->offline\n"));                }
                if(status.compulsionSwitch       != 0) { wprintf(_T("1->compulsionSwitch\n"));       }else{ wprintf(_T("0->compulsionSwitch\n"));       }
                if(status.overTemp               != 0) { wprintf(_T("1->overTemp\n"));               }else{ wprintf(_T("0->overTemp\n"));               }
                if(status.unrecoverableError     != 0) { wprintf(_T("1->unrecoverableError\n"));     }else{ wprintf(_T("0->unrecoverableError\n"));     }
                if(status.cutterError            != 0) { wprintf(_T("1->cutterError\n"));            }else{ wprintf(_T("0->cutterError\n"));            }
                if(status.mechError              != 0) { wprintf(_T("1->mechError\n"));              }else{ wprintf(_T("0->mechError\n"));              }
                if(status.pageModeCmdError       != 0) { wprintf(_T("1->pageModeCmdError\n"));       }else{ wprintf(_T("0->pageModeCmdError\n"));       }
                if(status.paperSizeError         != 0) { wprintf(_T("1->paperSizeError\n"));         }else{ wprintf(_T("0->paperSizeError\n"));         }
                if(status.presenterPaperJamError != 0) { wprintf(_T("1->presenterPaperJamError\n")); }else{ wprintf(_T("0->presenterPaperJamError\n")); }
                if(status.headUpError            != 0) { wprintf(_T("1->headUpError\n"));            }else{ wprintf(_T("0->headUpError\n"));            }
                if(status.blackMarkDetectStatus  != 0) { wprintf(_T("1->blackMarkDetectStatus\n"));  }else{ wprintf(_T("0->blackMarkDetectStatus\n"));  }
                if(status.paperEmpty             != 0) { wprintf(_T("1->paperEmpty\n"));             }else{ wprintf(_T("0->paperEmpty\n"));             }
                if(status.paperNearEmptyInner    != 0) { wprintf(_T("1->paperNearEmptyInner\n"));    }else{ wprintf(_T("0->paperNearEmptyInner\n"));    }
                if(status.paperNearEmptyOuter    != 0) { wprintf(_T("1->paperNearEmptyOuter\n"));    }else{ wprintf(_T("0->paperNearEmptyOuter\n"));    }
                if(status.stackerFull            != 0) { wprintf(_T("1->stackerFull\n"));            }else{ wprintf(_T("0->stackerFull\n"));            }
                if(status.etbAvailable           != 0) { wprintf(_T("1->etbAvailable\n"));           }else{ wprintf(_T("0->etbAvailable\n"));           }

                wprintf(_T("ETB Counter     : %d\n"), status.etbCounter);
                wprintf( _T("Presenter State : %d\n"), status.presenterState);

                // raw
                wprintf(_T("rawLength       = %d\n"), status.rawLength);
                for(i = 0; i < status.rawLength; i++)
                {
                    j += swprintf(raw + j, _T("%.2X "), status.raw[i]);
                }
                wprintf(_T("raw data        = %s\n"), raw);
            }
            else
            {
                dwError = GetLastError();
                switch(dwError)
                {
                    case ERROR_NOT_READY :
                        wprintf(_T("Power off.\n"));
                        break;
                    case ERROR_BROKEN_PIPE :
                        wprintf(_T("Printing system is working.\n"));
                        break;
                    default :
                        wprintf(_T("The status monitoring system error.\n"));
                        break;
                }
            }
        }
    }
}

wmain( int argc, WCHAR* argv[] )
{

    HKEY     hKey;
    DWORD    dwSize;
    BYTE     stlmDllPath[256];   memset(&stlmDllPath,   0, sizeof(stlmDllPath));
    wchar_t  stsmonDllPath[256]; memset(&stsmonDllPath, 0, sizeof(stsmonDllPath));

    if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, SMJPRINTER_LMPLUGREG_NAME, 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
    {
        if(RegQueryValueEx(hKey, NULL, NULL, NULL, stlmDllPath, &dwSize) == ERROR_SUCCESS)
        {
            memcpy(&stsmonDllPath, &stlmDllPath, 256);
            wchar_t * res = wcsstr( stsmonDllPath, SMJPRINTER_STLM_NAME );
            if ( res )
            {
                // fullpath --> stsmon.dll
                memcpy(res, SMJPRINTER_STSMON_NAME, sizeof(SMJPRINTER_STSMON_NAME));

                HMODULE hPLUGINDLL = LoadLibrary((LPCWSTR)stsmonDllPath);

                int ch;

                StatusCheck(hPLUGINDLL);

                _cputs( "\nPress: \'R\'(Retry) or \'E\'(Exit)\n" );
                do{
                    ch = _getch();
                    ch = toupper( ch );

                    if( ch == 'R' )
                    {
                        StatusCheck(hPLUGINDLL);

                        wprintf(_T("\nPress: \'R\'(Retry) or \'E\'(Exit)\n"));
                    }
                } while( ch != 'E' );

                FreeLibrary(hPLUGINDLL);
            }

        }
        
        RegCloseKey(hKey);
    }

    return 0;
}
