#pragma once

#include <windows.h>

#ifdef __cplusplus

extern "C" {

#ifndef STARIOPORT_ALREADY_DEFINED
#define STARIOPORT_ALREADY_DEFINED

typedef struct StarPrinterStatus_2_
{
  // printer status 1
  BOOL coverOpen;                     // Cover Status
  BOOL offline;                       // ONLINE/OFFLINE Status
  BOOL compulsionSwitch;              // not supported in TUP500

  // printer status 2
  BOOL overTemp;                      // Stopped by high head temperature
  BOOL unrecoverableError;            // Non-recoverable Error
  BOOL cutterError;                   // Auto-cutter Error
  BOOL mechError;                     // not supported in TUP500
  BOOL headThermistorError;           // Head Thermistor Error

  // printer status 3
  BOOL receiveBufferOverflow;         // Receive Buffer Overflow
  BOOL pageModeCmdError;              // Command Error (in Page Mode)
  BOOL blackMarkError;                // BM Error
  BOOL presenterPaperJamError;        // Presenter Paper Jam Error
  BOOL headUpError;                   // not supported in TUP500
  BOOL voltageError;                  // Voltage Error

  // printer status 4
  BOOL receiptBlackMarkDetection;     // not supported in TUP500
  BOOL receiptPaperEmpty;             // Paper End
  BOOL receiptPaperNearEmptyInner;    // Paper Near-end(Inner Side)
  BOOL receiptPaperNearEmptyOuter;    // not supported in TUP500

  // printer status 5
  BOOL presenterPaperPresent;         // not supported in TUP500
  BOOL peelerPaperPresent;            // not supported in TUP500
  BOOL stackerFull;                   // not supported in TUP500
  BOOL slipTOF;                       // not supported in TUP500
  BOOL slipCOF;                       // not supported in TUP500
  BOOL slipBOF;                       // not supported in TUP500
  BOOL validationPaperPresent;        // not supported in TUP500
  BOOL slipPaperPresent;              // not supported in TUP500

  // printer status 6
  BOOL etbAvailable;                  // ETB Available
  UCHAR etbCounter;                   // ETB Counter

  // printer status 7
  UCHAR presenterState;               // Presenter Paper Position

  // raw
  UINT32 rawLength;                   // Raw data Length
  UCHAR raw[63];                      // Raw data
} StarPrinterStatus_2;

#endif

BOOL WINAPI GetStarPrinterStatusA(LPCSTR queueName, StarPrinterStatus_2 * status);
BOOL WINAPI GetStarPrinterStatusW(LPCWSTR queueName, StarPrinterStatus_2 * status);

} // extern "C"
#endif

#ifdef UNICODE
#define GetStarPrinterStatus "GetStarPrinterStatusW"
typedef BOOL (WINAPI * STATUSCHK)(LPCWSTR, StarPrinterStatus_2 *);
#else
#define GetStarPrinterStatus "GetStarPrinterStatusA"
typedef BOOL (WINAPI * STATUSCHK)(LPCSTR,  StarPrinterStatus_2 *);
#endif // !UNICODE
