#include <tchar.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

#include "stsmon.h"

#define SMJPRINTER_PRINTER_NAME      _T("Star TUP500 (TUP542)")                                         // Printer Queue Name
#define SMJPRINTER_LMPLUGREG_NAME    _T("SOFTWARE\\StarMicronics\\SMJLMHOST2\\Star TUP500 (TUP542)")    // TUP500 registry storage destination
#define SMJPRINTER_STLM_NAME         _T("stlm.dll")                                                     // Star Language Monitor
#define SMJPRINTER_STSMON_NAME       _T("stsmon.dll")                                                   // Star Status   Monitor
#define GUID_MAX_LENGTH              1024

void StatusCheck(HMODULE hPLUGINDLL)
{
    wchar_t  raw[256]; memset(&raw, 0, sizeof(raw));
    DWORD    i = 0;
    int      j = 0;

    if( hPLUGINDLL != NULL )
    {

        STATUSCHK stlmplugIn = (STATUSCHK) GetProcAddress(hPLUGINDLL, GetStarPrinterStatus);

        if(stlmplugIn != NULL)
        {
            StarPrinterStatus_2 status;
            memset(&status, 0, sizeof(StarPrinterStatus_2));

            if((*stlmplugIn)(SMJPRINTER_PRINTER_NAME, &status))
            {
                // The error status value is 1 (true). 
                wprintf(_T("Printer Name: %s\n"), SMJPRINTER_PRINTER_NAME);
                if(status.coverOpen                  != 0) { wprintf(_T("1->coverOpen\n"));                  }else{ wprintf(_T("0->coverOpen\n"));                  }
                if(status.offline                    != 0) { wprintf(_T("1->offline\n"));                    }else{ wprintf(_T("0->offline\n"));                    }
                if(status.overTemp                   != 0) { wprintf(_T("1->overTemp\n"));                   }else{ wprintf(_T("0->overTemp\n"));                   }
                if(status.unrecoverableError         != 0) { wprintf(_T("1->unrecoverableError\n"));         }else{ wprintf(_T("0->unrecoverableError\n"));         }
                if(status.cutterError                != 0) { wprintf(_T("1->cutterError\n"));                }else{ wprintf(_T("0->cutterError\n"));                }
                if(status.headThermistorError        != 0) { wprintf(_T("1->headThermistorError\n"));        }else{ wprintf(_T("0->headThermistorError\n"));        }
                if(status.receiveBufferOverflow      != 0) { wprintf(_T("1->receiveBufferOverflow\n"));      }else{ wprintf(_T("0->receiveBufferOverflow\n"));      }
                if(status.pageModeCmdError           != 0) { wprintf(_T("1->pageModeCmdError\n"));           }else{ wprintf(_T("0->pageModeCmdError\n"));           }
                if(status.blackMarkError             != 0) { wprintf(_T("1->blackMarkError\n"));             }else{ wprintf(_T("0->blackMarkError\n"));             }
                if(status.presenterPaperJamError     != 0) { wprintf(_T("1->presenterPaperJamError\n"));     }else{ wprintf(_T("0->presenterPaperJamError\n"));     }
                if(status.voltageError               != 0) { wprintf(_T("1->voltageError\n"));               }else{ wprintf(_T("0->voltageError\n"));               }
                if(status.receiptPaperEmpty          != 0) { wprintf(_T("1->receiptPaperEmpty\n"));          }else{ wprintf(_T("0->receiptPaperEmpty\n"));          }
                if(status.receiptPaperNearEmptyInner != 0) { wprintf(_T("1->receiptPaperNearEmptyInner\n")); }else{ wprintf(_T("0->receiptPaperNearEmptyInner\n")); }
                if(status.etbAvailable               != 0) { wprintf(_T("1->etbAvailable\n"));               }else{ wprintf(_T("0->etbAvailable\n"));               }

                wprintf(_T("ETB Counter     : %d\n"), status.etbCounter);

                wprintf(_T("Presenter State : %d\n"), status.presenterState);

                // raw
                wprintf(_T("rawLength       = %d\n"), status.rawLength);
                for(i = 0; i < status.rawLength; i++)
                {
                    j += swprintf(raw + j, _T("%.2X "), status.raw[i]);
                }
                wprintf(_T("raw data        = %s\n"), raw);
            }
        }
    }
}

wmain( int argc, WCHAR* argv[] )
{

    HKEY     hKey;
    DWORD    dwSize;
    BYTE     stlmDllPath[256];   memset(&stlmDllPath,   0, sizeof(stlmDllPath));
    wchar_t  stsmonDllPath[256]; memset(&stsmonDllPath, 0, sizeof(stsmonDllPath));

    if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, SMJPRINTER_LMPLUGREG_NAME, 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
    {
        if(RegQueryValueEx(hKey, NULL, NULL, NULL, stlmDllPath, &dwSize) == ERROR_SUCCESS)
        {
            memcpy(&stsmonDllPath, &stlmDllPath, 256);
            wchar_t * res = wcsstr( stsmonDllPath, SMJPRINTER_STLM_NAME );
            if ( res )
            {
                // fullpath --> stsmon.dll
                memcpy(res, SMJPRINTER_STSMON_NAME, sizeof(SMJPRINTER_STSMON_NAME));

                HMODULE hPLUGINDLL = LoadLibrary((LPCWSTR)stsmonDllPath);

                int ch;

                StatusCheck(hPLUGINDLL);

                _cputs( "\nPress: \'R\'(Retry) or \'E\'(Exit)\n\n" );
                do{
                    ch = _getch();
                    ch = toupper( ch );

                    if( ch == 'R' )
                    {
                        StatusCheck(hPLUGINDLL);

                        wprintf(_T("\nPress: \'R\'(Retry) or \'E\'(Exit)\n\n"));
                    }
                } while( ch != 'E' );

                FreeLibrary(hPLUGINDLL);
            }

        }
        
        RegCloseKey(hKey);
    }

    return 0;
}
