#pragma once

#include <windows.h>

#ifdef __cplusplus

extern "C" {

#ifndef STARIOPORT_ALREADY_DEFINED
#define STARIOPORT_ALREADY_DEFINED

typedef struct StarPrinterStatus_
{
  // printer status 1           //(true = error status)
  BOOL coverOpen;               // cover open
  BOOL offline;                 // offline
  BOOL compulsionSwitch;        // compulsion switch

  // printer status 2
  BOOL overTemp;                // over temp
  BOOL unrecoverableError;      // unrecoverable error
  BOOL cutterError;             // cutter error
  BOOL mechError;               // machine error

  // printer status 3
  BOOL pageModeCmdError;        // page mode command error
  BOOL paperSizeError;          // paper size error
  BOOL presenterPaperJamError;  // presenter paper jam error
  BOOL headUpError;             // head up error

  // printer status 4
  BOOL blackMarkDetectStatus;   // black mark detect status
  BOOL paperEmpty;              // paper empty
  BOOL paperNearEmptyInner;     // paper near empty innner
  BOOL paperNearEmptyOuter;     // paper near empty outer

  // printer status 5
  BOOL stackerFull;             // stacker full

  // printer status 6
  BOOL etbAvailable;            // etb available
  BYTE etbCounter;              // etb counter

  // printer status 7
  BYTE presenterState;          // presenter state

  // raw
  DWORD rawLength;              // raw data length
  BYTE raw[63];                 // raw data
} StarPrinterStatus;

#endif

BOOL WINAPI GetStarPrinterStatusA(LPCSTR queueName, StarPrinterStatus * status);
BOOL WINAPI GetStarPrinterStatusW(LPCWSTR queueName, StarPrinterStatus * status);

} // extern "C"
#endif

#ifdef UNICODE
#define GetStarPrinterStatus "GetStarPrinterStatusW"
typedef BOOL (WINAPI * STATUSCHK)(LPCWSTR, StarPrinterStatus *);
#else
#define GetStarPrinterStatus "GetStarPrinterStatusA"
typedef BOOL (WINAPI * STATUSCHK)(LPCSTR,  StarPrinterStatus *);
#endif // !UNICODE
