VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "SMJ Sample Program"
   ClientHeight    =   7755
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   5055
   LinkTopic       =   "Form1"
   ScaleHeight     =   7755
   ScaleWidth      =   5055
   StartUpPosition =   3  'Windows ̊l
   Begin VB.TextBox rawDataText 
      Height          =   270
      Left            =   360
      TabIndex        =   24
      Text            =   "Raw Date"
      Top             =   7200
      Width           =   4335
   End
   Begin VB.TextBox presenterStateText 
      Height          =   270
      Left            =   360
      TabIndex        =   22
      Top             =   6720
      Width           =   495
   End
   Begin VB.CheckBox etbAvailableCheck 
      Caption         =   "etb available"
      Height          =   255
      Left            =   360
      TabIndex        =   21
      Top             =   6000
      Width           =   3375
   End
   Begin VB.CheckBox stackerFullCheck 
      Caption         =   "stacker full"
      Height          =   255
      Left            =   360
      TabIndex        =   20
      Top             =   5700
      Width           =   3375
   End
   Begin VB.CheckBox paperNearEmptyOuterCheck 
      Caption         =   "paper near empty outer"
      Height          =   255
      Left            =   360
      TabIndex        =   19
      Top             =   5400
      Width           =   3375
   End
   Begin VB.CheckBox paperNearEmptyInnerCheck 
      Caption         =   "paper near empty inner"
      Height          =   255
      Left            =   360
      TabIndex        =   18
      Top             =   5115
      Width           =   3375
   End
   Begin VB.CheckBox paperEmptyCheck 
      Caption         =   "paper empty"
      Height          =   255
      Left            =   360
      TabIndex        =   17
      Top             =   4815
      Width           =   3375
   End
   Begin VB.CheckBox blackMarkDetectStatusCheck 
      Caption         =   "black mark detect status"
      Height          =   255
      Left            =   360
      TabIndex        =   16
      Top             =   4530
      Width           =   3375
   End
   Begin VB.CheckBox headUpErrorCheck 
      Caption         =   "head up error"
      Height          =   255
      Left            =   360
      TabIndex        =   15
      Top             =   4230
      Width           =   3375
   End
   Begin VB.CheckBox presenterPaperJamErrorCheck 
      Caption         =   "presenter paper jam error"
      Height          =   255
      Left            =   360
      TabIndex        =   14
      Top             =   3930
      Width           =   3375
   End
   Begin VB.CheckBox compulsionSwitchCheck 
      Caption         =   "compulsion switch"
      Height          =   255
      Left            =   360
      TabIndex        =   13
      Top             =   1875
      Width           =   3375
   End
   Begin VB.Frame Frame1 
      Height          =   135
      Left            =   240
      TabIndex        =   12
      Top             =   1080
      Width           =   4575
   End
   Begin VB.TextBox etbCounterText 
      Height          =   270
      Left            =   360
      TabIndex        =   11
      Top             =   6360
      Width           =   495
   End
   Begin VB.CheckBox paperSizeErrorCheck 
      Caption         =   "paper size error"
      Height          =   255
      Left            =   360
      TabIndex        =   10
      Top             =   3645
      Width           =   3375
   End
   Begin VB.CheckBox pageModeCmdErrorCheck 
      Caption         =   "page mode command error"
      Height          =   255
      Left            =   360
      TabIndex        =   9
      Top             =   3345
      Width           =   3375
   End
   Begin VB.CheckBox mechErrorCheck 
      Caption         =   "machine error"
      Height          =   255
      Left            =   360
      TabIndex        =   8
      Top             =   3060
      Width           =   3375
   End
   Begin VB.CheckBox cutterErrorCheck 
      Caption         =   "cutter error"
      Height          =   255
      Left            =   360
      TabIndex        =   7
      Top             =   2760
      Width           =   3375
   End
   Begin VB.CheckBox unrecoverablEerrorCheck 
      Caption         =   "unrecoverable error"
      Height          =   255
      Left            =   360
      TabIndex        =   6
      Top             =   2460
      Width           =   3375
   End
   Begin VB.ComboBox printerQueueCombo 
      Height          =   300
      Left            =   360
      TabIndex        =   5
      Text            =   "printer Queue"
      Top             =   240
      Width           =   4335
   End
   Begin VB.CheckBox coverOpenCheck 
      Caption         =   "cover open"
      Height          =   255
      Left            =   360
      TabIndex        =   3
      Top             =   1290
      Width           =   3375
   End
   Begin VB.CheckBox offlineCheck 
      Caption         =   "offline"
      Height          =   255
      Left            =   360
      TabIndex        =   2
      Top             =   1590
      Width           =   3375
   End
   Begin VB.CheckBox overTempCheck 
      Caption         =   "over temp"
      Height          =   255
      Left            =   360
      TabIndex        =   1
      Top             =   2175
      Width           =   3375
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Get Status"
      Height          =   255
      Left            =   360
      TabIndex        =   0
      Top             =   720
      Width           =   1815
   End
   Begin VB.Label presenterStateLabel 
      Caption         =   "presenter state"
      Height          =   255
      Left            =   960
      TabIndex        =   23
      Top             =   6765
      Width           =   2895
   End
   Begin VB.Label etbCounterLabel 
      Caption         =   "etb counter"
      Height          =   255
      Left            =   960
      TabIndex        =   4
      Top             =   6405
      Width           =   2895
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub Command1_Click()
    Dim i As Long
    Dim currentStatus As StarPrinterStatus
    
    If (GetStarPrinterStatus(printerQueueCombo.Text, currentStatus) <> 0) Then
        
        'The error status value is 1 (true).
        
        'cover open
        If (currentStatus.coverOpen = 0) Then
            coverOpenCheck.Value = vbUnchecked
        Else
            coverOpenCheck.Value = vbChecked
        End If
        
        'online
        If (currentStatus.offline = 0) Then
            offlineCheck.Value = vbUnchecked
        Else
            offlineCheck.Value = vbChecked
        End If
        
        'compulsion switch
        If (currentStatus.compulsionSwitch = 0) Then
            compulsionSwitchCheck.Value = vbUnchecked
        Else
            compulsionSwitchCheck.Value = vbChecked
        End If
        
        'over temp
        If (currentStatus.overTemp = 0) Then
            overTempCheck.Value = vbUnchecked
        Else
            overTempCheck.Value = vbChecked
        End If
        
        'unrecoverable error
        If (currentStatus.unrecoverableError = 0) Then
            unrecoverablEerrorCheck.Value = vbUnchecked
        Else
            unrecoverablEerrorCheck.Value = vbChecked
        End If
        
        'cutter error
        If (currentStatus.cutterError = 0) Then
            cutterErrorCheck.Value = vbUnchecked
        Else
            cutterErrorCheck.Value = vbChecked
        End If
        
        'machine error
        If (currentStatus.mechError = 0) Then
            mechErrorCheck.Value = vbUnchecked
        Else
            mechErrorCheck.Value = vbChecked
        End If
        
        'page mode command error
        If (currentStatus.pageModeCmdError = 0) Then
            pageModeCmdErrorCheck.Value = vbUnchecked
        Else
            pageModeCmdErrorCheck.Value = vbChecked
        End If
        
        'paper size error
        If (currentStatus.paperSizeError = 0) Then
            paperSizeErrorCheck.Value = vbUnchecked
        Else
            paperSizeErrorCheck.Value = vbChecked
        End If
        
        'presenter paper jam error
        If (currentStatus.presenterPaperJamError = 0) Then
            presenterPaperJamErrorCheck.Value = vbUnchecked
        Else
            presenterPaperJamErrorCheck.Value = vbChecked
        End If
        
        'head up error
        If (currentStatus.headUpError = 0) Then
            headUpErrorCheck.Value = vbUnchecked
        Else
            headUpErrorCheck.Value = vbChecked
        End If
        
        'black mark detect status
        If (currentStatus.blackMarkDetectStatus = 0) Then
            blackMarkDetectStatusCheck.Value = vbUnchecked
        Else
            blackMarkDetectStatusCheck.Value = vbChecked
        End If
        
        'paper empty
        If (currentStatus.paperEmpty = 0) Then
            paperEmptyCheck.Value = vbUnchecked
        Else
            paperEmptyCheck.Value = vbChecked
        End If
        
        'paper near empty inner
        If (currentStatus.paperNearEmptyInner = 0) Then
            paperNearEmptyInnerCheck.Value = vbUnchecked
        Else
            paperNearEmptyInnerCheck.Value = vbChecked
        End If
        
        'paper near empty outer
        If (currentStatus.paperNearEmptyOuter = 0) Then
            paperNearEmptyOuterCheck.Value = vbUnchecked
        Else
            paperNearEmptyOuterCheck.Value = vbChecked
        End If
        
        'stacker full
        If (currentStatus.stackerFull = 0) Then
            stackerFullCheck.Value = vbUnchecked
        Else
            stackerFullCheck.Value = vbChecked
        End If
        
        'etb available
        If (currentStatus.etbAvailable = 0) Then
            etbAvailableCheck.Value = vbUnchecked
        Else
            etbAvailableCheck.Value = vbChecked
        End If
        
        'etb counter
        etbCounterText.Text = Str$(currentStatus.etbCounter)
        etbCounterLabel.Caption = "etb counter value"
    
        'presenter state
        presenterStateText.Text = Str$(currentStatus.presenterState)
        presenterStateLabel.Caption = "presenter state value"
    
        'Raw Data
        rawDataText.Text = "Raw Data: "
        For i = 0 To currentStatus.rawLength - 1
            rawDataText.Text = rawDataText.Text + Right("00" + Hex(currentStatus.raw(i)), 2) + " "
        Next i

    Else

        Select Case Err.LastDllError
        Case ERROR_NOT_READY
            Call MsgBox("Power off.", vbOKOnly, "Error")
        Case ERROR_BROKEN_PIPE
            Call MsgBox("Printing system is working.", vbOKOnly, "Error")
        Case Else
            Call MsgBox("The status monitoring system error.", vbOKOnly, "Error")
        End Select

    End If
End Sub

Private Sub Form_Load()
    
    Dim PrinterInfo()         As PRINTER_INFO_2
    Dim DriverInfo()          As DRIVER_INFO_3
    Dim byPrinterInfoBuffer() As Byte
    Dim byDriverInfoBuffer()  As Byte
    Dim strSMJLanguageMonitor As String
    Dim strPrinterName        As String * 256
    Dim strDriverName0        As String * 256
    Dim strDriverName1        As String * 256
    Dim strMonitorName        As String * 256
    Dim nPrinterInfoReturned  As Long
    Dim nDriverInfoReturned   As Long
    Dim nNeeded               As Long
    Dim nResultCode           As Long
    Dim i                     As Long
    Dim j                     As Long
    
    strSMJLanguageMonitor = SMJLMHOST2DLL
    
    printerQueueCombo.Text = ""
    
    nResultCode = EnumPrinters(PRINTER_ENUM_LOCAL, _
                               vbNullString, _
                               2, _
                               ByVal vbNullString, _
                               0, _
                               nNeeded, _
                               nPrinterInfoReturned)
    
    If nNeeded > 0 Then
        ReDim byPrinterInfoBuffer(nNeeded - 1)
        
        nResultCode = EnumPrinters(PRINTER_ENUM_LOCAL, _
                                   vbNullString, _
                                   2, _
                                   byPrinterInfoBuffer(0), _
                                   nNeeded, _
                                   nNeeded, _
                                   nPrinterInfoReturned)
        
        ReDim PrinterInfo(nPrinterInfoReturned - 1)
        
        MoveMemory PrinterInfo(0), byPrinterInfoBuffer(0), Len(PrinterInfo(0)) * nPrinterInfoReturned
        
        nResultCode = EnumPrinterDrivers(vbNullString, _
                                         vbNullString, _
                                         3, _
                                         ByVal vbNullString, _
                                         0, _
                                         nNeeded, _
                                         nDriverInfoReturned)
        
        If nNeeded > 0 Then
            ReDim byDriverInfoBuffer(nNeeded - 1)
            
            nResultCode = EnumPrinterDrivers(vbNullString, _
                                             vbNullString, _
                                             3, _
                                             byDriverInfoBuffer(0), _
                                             nNeeded, _
                                             nNeeded, _
                                             nDriverInfoReturned)
            
            ReDim DriverInfo(nDriverInfoReturned - 1)
            
            MoveMemory DriverInfo(0), byDriverInfoBuffer(0), Len(DriverInfo(0)) * nDriverInfoReturned
            
            For i = 0 To nPrinterInfoReturned - 1
                nResultCode = lstrcpy(ByVal strPrinterName, ByVal "")
                nResultCode = lstrcpy(ByVal strDriverName0, ByVal "")
                
                nResultCode = lstrcpy(ByVal strPrinterName, ByVal PrinterInfo(i).pPrinterName)
                nResultCode = lstrcpy(ByVal strDriverName0, ByVal PrinterInfo(i).pDriverName)
                
                For j = 0 To nDriverInfoReturned - 1
                    nResultCode = lstrcpy(ByVal strDriverName1, ByVal "")
                    nResultCode = lstrcpy(ByVal strDriverName1, ByVal DriverInfo(j).pName)
                    
                    If Left$(strDriverName0, InStr(strDriverName0, vbNullChar) - 1) = Left$(strDriverName1, InStr(strDriverName1, vbNullChar) - 1) Then
                        nResultCode = lstrcpy(ByVal strMonitorName, "")
                        nResultCode = lstrcpy(ByVal strMonitorName, ByVal DriverInfo(j).pMonitorName)
                        
                        If Left$(strMonitorName, InStr(strMonitorName, vbNullChar) - 1) = strSMJLanguageMonitor Then
                            printerQueueCombo.AddItem strPrinterName
                        End If
                        
                        Exit For
                    End If
                Next j
            Next i
            
            If printerQueueCombo.ListCount Then printerQueueCombo.ListIndex = 0
        End If
    End If

    Dim hKey           As Long
    Dim lRes           As Long
    Dim RegGetValue    As Variant
    Dim stlmFullPath   As String
    Dim stsmonFullPath As String

    'stsmon Dll Load
    lRes = RegOpenKeyEx(HKEY_LOCAL_MACHINE, STLM_REG_PATH, 1, KEY_QUERY_VALUE, hKey)
    If (lRes <> ERROR_SUCCESS) Then Exit Sub
    
    stlmFullPath = String(256, vbNullChar)
    lRes = RegQueryValueEx(hKey, "", 0, 1, ByVal stlmFullPath, Len(stlmFullPath))
    
    If lRes = ERROR_SUCCESS Then
        'fullpath  stlm.dll --> stsmon.dll
        stsmonFullPath = Replace(stlmFullPath, STLM_NAME, STSMON_NAME)
    
        RegGetValue = Left$(stsmonFullPath, InStr(stsmonFullPath, vbNullChar) - 1)
    
        IncludeLibrary (RegGetValue)
    End If
 
    RegCloseKey (hKey)
  
End Sub

